get_sw_txt_path() {
sw_txt_path_list=$(find /vendor -name "*_sw.txt")
if [ "${sw_txt_path_list}" == "" ]; then
  ui_print "- 未找到*_sw.txt文件 不支持此设备"
  abort ""
fi
#部分设备存在多个*_sw.txt
local txt_num=0
local dir_num=0
ui_print "mcfg_sw"
for path in ${sw_txt_path_list}; do
  #判断是否为*_sw.txt
  if [ "$(grep '\/mcfg_sw.mbn' "${path}")" != "" ]; then
    eval dir_path${dir_num}="${path%/*}"
    #去除重复项
    if [ "$(eval echo \${dir_path${dir_num}})" == "$(eval echo \${dir_path$((${dir_num}-1))})" ]; then
      eval dir_path${dir_num}=""
      continue
    fi
    mcfg_sw_dir_path=$(eval echo \${dir_path${dir_num}})
    ui_print "${dir_num} ${mcfg_sw_dir_path}"
    let dir_num++
  fi
done
ui_print ""
ui_print "*_sw.txt"
for path in ${sw_txt_path_list}; do
  if [ "$(grep '\/mcfg_sw.mbn' "${path}")" != "" ]; then
    eval txt_path${txt_num}="${path}"
    if [ "$(eval echo \${txt_path${txt_num}})" == "$(eval echo \${txt_path$((${txt_num}-1))})" ]; then
      eval txt_path${txt_num}=""
      continue
    fi
    sw_txt_path=$(eval echo \${txt_path${txt_num}})
    ui_print "${txt_num} ${sw_txt_path}"
    let txt_num++
  fi
done
ui_print ""
}

compare_num() {
#compare_result=1大于 =2小于 =3等于 =0比较失败
if [[ "$1" == "" ]] || [[ "$2" == "" ]]; then
  compare_result=0
else
  compare_result=$(echo "$1 $2" | awk '{ if($1>$2) print "1"; else if($1<$2) print "2"; else if($1==$2) print "3" }')
fi
}

mod_ver_check() {
ver_new_mod=$(grep 'version=' "${MODPATH}/module.prop" | sed -e 's/version=//g' | sed -e 's/v//g')
ui_print "- 模块: ${MODID}"
ui_print "- 当前安装版本: ${ver_new_mod}"
if [ -f "/data/adb/modules/${MODID}/module.prop" ]; then
  ver_old_mod=$(grep 'version=' "/data/adb/modules/${MODID}/module.prop" | sed -e 's/version=//g' | sed -e 's/v//g')
  compare_num "${ver_new_mod}" "${ver_old_mod}"
  ui_print "- 已安装版本: ${ver_old_mod}"
  if [ "${compare_result}" == "3" ]; then
    ui_print "- 正在覆盖安装"
  elif [ "${compare_result}" == "1" ]; then
    ui_print "- 正在更新模块"
  elif [ "${compare_result}" == "2" ]; then
    if [ -f "/data/adb/modules/${MODID}/update" ]; then
      ui_print "- 已存在待重启的更新版本"
      ui_print "- ! ! ! 正在覆盖安装旧版 ! ! !"
      sleep 3
    else
      ui_print "- 已存在更新版本"
      abort ""
    fi
  fi
  exist_old_mod=1
fi
ui_print ""
}

grep_cn="grep -E '\/CHINA\/|\/China\/|\/china\/|\/CMCC\/|\/Cmcc\/|\/cmcc\/|\/CT\/|\/Ct\/|\/ct\/|\/CU\/|\/Cu\/|\/cu\/'"

sw_txt_check() {
local txt_num=0
sw_txt_path=$(eval echo \${txt_path${txt_num}})
while [ "${sw_txt_path}" != "" ]; do
  if [ "$(${grep_cn} "${sw_txt_path}")" != "" ]; then
    if [ "${exist_old_mod}" != "1" ]; then
      ui_print "- 当前已存在大陆运营商VoLTE相关文件"
      ui_print "- 若已安装同类模块 请先卸载并重启后安装"
      abort ""
    fi
    #sw_txt_clean=1
  fi
  let txt_num++
  sw_txt_path=$(eval echo \${txt_path${txt_num}})
done
}

get_platform() {
brand_name=$(getprop | grep '\[ro.product.brand\]' | awk -F '[]:[]' '{print $5}')
model_name=$(getprop | grep '\[ro.product.model\]' | awk -F '[]:[]' '{print $5}')
platform_name=$(getprop | grep '\[ro.board.platform\]' | awk -F '[]:[]' '{print $5}')
kernel_ver=$(uname -r | awk 'BEGIN{FS=".";OFS="."}{print $1,$2}')
android_ver=$(getprop | grep '\[ro.build.version.release\]' | awk -F '[]:[]' '{print $5}')
carrier1=$(getprop | grep '\[gsm.sim.operator.alpha\]' | awk -F '[]:[]' '{print $5}')
carrier=$(getprop | grep '\[gsm.operator.alpha\]' | awk -F '[]:[]' '{print $5}')
#ui_print "品牌: ${brand_name}"
ui_print "- 型号: ${brand_name} ${model_name}"
ui_print "- 平台: ${platform_name}"
ui_print "- 内核: ${kernel_ver}"
ui_print "- 安卓: ${android_ver}"
ui_print "- 运营商: ${carrier} (${carrier1})"
ui_print ""
if [ "${platform_name}" == "sm6150" ]; then
  platform_name=sm8150
elif [ "${platform_name}" == "sdm710" ]; then
  platform_name=sdm845
fi
}

env_check() {
mod_ver_check
sw_txt_check
get_platform
if [ ! -d "${MODPATH}/mcfg/${kernel_ver}" ]; then
  ui_print "- 暂不支持此平台"
  abort ""
fi
}

cp_mcfg() {
local dir_num=0
mcfg_sw_dir_path=$(eval echo \${dir_path${dir_num}})
while [ "${mcfg_sw_dir_path}" != "" ]; do
  ui_print "- 正在复制mcfg_sw ${dir_num}"
  mkdir -p "${MODPATH}/system${mcfg_sw_dir_path}"
  cp -rf "${MODPATH}/mcfg/${kernel_ver}/mcfg_sw/generic" "${MODPATH}/system${mcfg_sw_dir_path}/"
  let dir_num++
  mcfg_sw_dir_path=$(eval echo \${dir_path${dir_num}})
done
ui_print ""
}

mcfg_sw_dir_replace() {
mcfg_sw_dir_check=$(find "${MODPATH}/mcfg/${kernel_ver}/mcfg_sw" -name "mcfg_sw.mbn" | ${grep_cn} -v)
if [ "${mcfg_sw_dir_check}" != "" ]; then
  ui_print "- mcfg_sw_dir_replace=1"
  mcfg_sw_dir_replace=1
  local dir_num=0
  mcfg_sw_dir_path=$(eval echo \${dir_path${dir_num}})
  while [ "${mcfg_sw_dir_path}" != "" ]; do
    mktouch "$MODPATH/system${mcfg_sw_dir_path}/generic/.replace"
    let dir_num++
    mcfg_sw_dir_path=$(eval echo \${dir_path${dir_num}})
  done
fi
}

mod_sw_txt() {
mcfg_sw_dir_replace
local txt_num=0
sw_txt_path=$(eval echo \${txt_path${txt_num}})
mod_sw_txt_path="${MODPATH}/system${sw_txt_path}"
while [ "${sw_txt_path}" != "" ]; do
  if [ "${mcfg_sw_dir_replace}" != "1" ]; then
    cp -f "${sw_txt_path}" "${mod_sw_txt_path}"
    if [ "$(${grep_cn} "${sw_txt_path}")" != "" ]; then
      ui_print "- 正在清理*_sw.txt ${txt_num}"
      sed -i '/\/CHINA\//d;/\/China\//d;/\/china\//d' "${mod_sw_txt_path}"
      sed -i '/\/CMCC\//d;/\/Cmcc\//d;/\/cmcc\//d' "${mod_sw_txt_path}"
      sed -i '/\/CT\//d;/\/Ct\//d;/\/ct\//d' "${mod_sw_txt_path}"
      sed -i '/\/CU\//d;/\/Cu\//d;/\/cu\//d' "${mod_sw_txt_path}"
    fi
  fi
  ui_print "- 正在修改*_sw.txt ${txt_num}"
  echo "" >> "${mod_sw_txt_path}"
  mcfg_sw_mbn_path=$(find "${MODPATH}/mcfg/${kernel_ver}/mcfg_sw" -name "mcfg_sw.mbn" | sed -e 's/\/mcfg_sw\//@/g' | awk -F '@' '{print $2}' | sed -e 's/^/mcfg_sw\//g')
  for mbn_path in ${mcfg_sw_mbn_path}; do
    echo "${mbn_path}" >> "${mod_sw_txt_path}"
    #ui_print "${mbn_path}"
  done
  let txt_num++
  sw_txt_path=$(eval echo \${txt_path${txt_num}})
  mod_sw_txt_path="${MODPATH}/system${sw_txt_path}"
done
ui_print ""
}

write_prop() {
#if [ "$(getprop | grep "$(echo "$1" | awk -F '=' '{print $1}')")" == "" ]; then
  echo "$1" >> "${MODPATH}/system.prop"
  ui_print "$1"
#fi
}

add_prop() {
ui_print "- 正在添加prop"
ui_print ""
#compare_num "${ver_old_mod}" "1.4"
#if [ "${compare_result}" == "1" ]; then
#  cp -f "/data/adb/modules/${MODID}/system.prop" "${MODPATH}/system.prop"
#else
  rm -f "${MODPATH}/system.prop"
  write_prop "persist.dbg.volte_avail_ovr=1"
  write_prop "persist.dbg.vt_avail_ovr=1"
  write_prop "persist.dbg.wfc_avail_ovr=1"
  write_prop "persist.dbg.allow_ims_off=1"
  write_prop "persist.radio.calls.on.ims=1"
#  if [ "$(echo ${brand_name} | grep 'google')" == "" ]; then
#    write_prop "persist.radio.VT_ENABLE=1"
#    write_prop "persist.radio.VT_HYBRID_ENABLE=1"
    write_prop "persist.volte_enalbed_by_hw=1"
    write_prop "persist.dbg.ims_volte_enable=1"
    write_prop "persist.radio.data_con_rprt=1"
    write_prop "persist.radio.data_ltd_sys_ind=1"
    write_prop "persist.radio.rat_on=combine"
#    write_prop "ro.mtk_ims_support=1"
#    write_prop "ro.mtk_volte_support=1"
#    write_prop "persist.mtk.volte.enable=1"
#  fi
#fi
ui_print ""
}

clean_file() {
ui_print "- 正在清理Radio缓存"
delete_file_path=$(find /data/vendor -name "mcfg_sw.mbn")
delete_dir_path=${delete_file_path%/*}
#for delete_dir in ${delete_dir_path}; do
#  ui_print "${delete_dir}"
#  rm -rf "${delete_dir}"
#done
for delete_file in ${delete_file_path}; do
  ui_print "${delete_file}"
  rm -rf "${delete_file}"
done
rm -rf /data/vendor/modem*
rm -rf /data/vendor/radio
rm -rf "${MODPATH}/mcfg"
ui_print ""
}

ui_print ""
ui_print "********************"
ui_print ""
ui_print "- 建议模块安装完成后在当前界面截图保存"
ui_print "- 提交bug附上此界面截图"
ui_print ""
ui_print "- 重启后进入 设置-网络和互联网-移动网络-确保VoLTE选项已打开"
ui_print "- 拨号界面输入*#*#4636#*#*-手机信息-右上角三小点-查看ims服务状态"
ui_print ""

get_sw_txt_path
env_check
cp_mcfg
mod_sw_txt
add_prop
clean_file

ui_print "- 安装完成"
ui_print ""
ui_print "********************"
ui_print ""
sleep 5
